#include "hal_base.h"
#include "hal_gpio.h"
#include "hal_t2n.h"


/* ʼPA5 PWM200; PA6 PWM201 PB3 PWM210˿ */
void GPIO_init()
{
	gpio_init_t init;
	init.io = GPIO_OUTPUT;
	init.level = GPIO_LOW_LEVEL;
	init.mode = GPIO_DIGIT_MODE;
	init.pu = DISABLE;
	init.pd = DISABLE;
	init.drive = GPIO_LOW_DRIVER;
	init.od = DISABLE;
	init.smit = GPIO_1_5_TO_3_0_SMIT;
	init.cur_ctr = DISABLE;

	gpio_init(PA_TYPE, GPIO_PIN_5, &init);
	gpio_init(PA_TYPE, GPIO_PIN_6, &init);
	gpio_init(PB_TYPE, GPIO_PIN_3, &init);
}

/* PWM200 PWM210ֱ20KHZ, 4KHZPWMΣռձȾΪ50% */
void pwm_test1(void)
{
	t2n_init_t t_init;
		
	t_init.mode = T2N_DOUBLE_PWM_MODE;
	t_init.clk_div = T2N_CLK_DIV_8;
	t_init.pwm_en = PWM0_EN;
	t_init.polarity = T2N_PWM_ALL_LOW;
	t_init.period = 100;
	t_init.pwm0_prec = 50;  
	t_init.pos = 1;
	t2n_init(T20_TYPE, &t_init);

	t_init.period = 500;
	t_init.pwm0_prec = 250;
	t2n_init(T21_TYPE, &t_init);

	t2n_start(T20_TYPE);
	t2n_start(T21_TYPE);
}

/* PWM200,PWM201ͬʱΪ20KHZPWMռձȷֱΪ25%50% */
void pwm_test2(void)
{
	t2n_init_t t_init;

	t_init.mode = T2N_DOUBLE_PWM_MODE;
	t_init.clk_div = T2N_CLK_DIV_8;
	t_init.pwm_en = PWM_ALL_EN;
	t_init.polarity = T2N_PWM_ALL_LOW;
	t_init.period = 100;
	t_init.pwm0_prec = 25;
	t_init.pwm1_prec = 50;
	t_init.pos = 1;
	t2n_init(T20_TYPE, &t_init);

	t2n_start(T20_TYPE);
}

void main() 
{
	// RAMʼ
	ram_clear();
	// clockʼѡHRC,Ƶʹclock 
	clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);
	//GPIOʼ
	GPIO_init();

	/* caseֻѡһһע͵ */
	pwm_test1();

	//pwm_test2();

	while (1) {
		// ι
		CLRWDT();
	}
}
